#!/bin/sh

mkdir /ram/logoup
cp ./* /ram/logoup 
cd /ram/logoup

oldlogo=./oldlogo.img
newlogo=./newlogo.img

cat /dev/mtd3 > $oldlogo

f=`wc -c ./logo.bmp.gz`
size=${f%%./logo.bmp.gz}
size=$((size))

max=262144
if [ $max -lt $size ]; then 
    echo " Bad size logo.bmp.gz . Max size 262144."
    exit 1; 
fi

rm ./temp_logo.img
cat ./logo.bmp.gz > $newlogo
dd if=$oldlogo ibs=1 skip=$size of=./temp_logo.img obs=1 count=$((262144-$size))
cat ./temp_logo.img >> $newlogo

flash_eraseall /dev/mtd3
echo erase===
cat $newlogo > /dev/mtd3
echo cat===
fw_setenv showlogo
fw_setenv showlogo yes

# Screen size 576*720
# X - Left upper conner of logo  
fw_setenv logo_x   0
# Y - Left upper conner of logo 
fw_setenv logo_y   0
# Background color ARGB (Always A = 00)
#fw_setenv bg_color 0x00284858
fw_setenv bg_color 0x00000000
# Text color ARGB (Always A = 00)
#fw_setenv fg_color 0x00c4e4ec
fw_setenv fg_color 0x00FFFFFF
